<?php
/*
Plugin Name: Varaus Core
Plugin URI: http://themeforest.net/user/wpoceans
Description: Plugin to contain shortcodes and custom post types of the varaus theme.
Author: wpoceans
Author URI: http://themeforest.net/user/wpoceans/portfolio
Version: 1.0.4
Text Domain: varaus-core
*/

if (!function_exists('varaus_block_direct_access')) {
  function varaus_block_direct_access()
  {
    if (!defined('ABSPATH')) {
      exit('Forbidden');
    }
  }
}

// Plugin URL
define('VARAUS_PLUGIN_URL', plugins_url('/', __FILE__));

// Plugin PATH
define('VARAUS_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('VARAUS_PLUGIN_ASTS', VARAUS_PLUGIN_URL . 'assets');
define('VARAUS_PLUGIN_IMGS', VARAUS_PLUGIN_ASTS . '/images');
define('VARAUS_PLUGIN_INC', VARAUS_PLUGIN_PATH . 'include');

// DIRECTORY SEPARATOR
define('DS', DIRECTORY_SEPARATOR);

// Varaus Elementor Shortcode Path
define('VARAUS_EM_SHORTCODE_BASE_PATH', VARAUS_PLUGIN_PATH . 'elementor/');
define('VARAUS_EM_SHORTCODE_PATH', VARAUS_EM_SHORTCODE_BASE_PATH . 'widgets/');

/**
 * Check if Codestar Framework is Active or Not!
 */
function varaus_framework_active()
{
  return (defined('CS_VERSION')) ? true : false;
}

/* VARAUS_THEME_NAME_PLUGIN */
define('VARAUS_THEME_NAME_PLUGIN', 'Varaus');

// Initial File
include_once(ABSPATH . 'wp-admin/includes/plugin.php');
if (is_plugin_active('varaus-core/varaus-core.php')) {

  // Custom Post Type
  require_once(VARAUS_PLUGIN_INC . '/custom-post-type.php');

  if (is_plugin_active('kingcomposer/kingcomposer.php')) {

    define('VARAUS_KC_SHORTCODE_BASE_PATH', VARAUS_PLUGIN_PATH . 'kc/');
    define('VARAUS_KC_SHORTCODE_PATH', VARAUS_KC_SHORTCODE_BASE_PATH . 'shortcodes/');
    // Shortcodes
    require_once(VARAUS_KC_SHORTCODE_BASE_PATH . '/kc-setup.php');
    require_once(VARAUS_KC_SHORTCODE_BASE_PATH . '/library.php');
  }

  // Theme Custom Shortcode
  require_once(VARAUS_PLUGIN_INC . '/custom-shortcodes/theme-shortcodes.php');
  require_once(VARAUS_PLUGIN_INC . '/custom-shortcodes/custom-shortcodes.php');

  // Importer
  require_once(VARAUS_PLUGIN_INC . '/demo/importer.php');


  if (class_exists('WP_Widget') && is_plugin_active('codestar-framework/cs-framework.php')) {
    // Widgets

    require_once(VARAUS_PLUGIN_INC . '/widgets/nav-widget.php');
    require_once(VARAUS_PLUGIN_INC . '/widgets/recent-posts.php');
    require_once(VARAUS_PLUGIN_INC . '/widgets/footer-posts.php');
    require_once(VARAUS_PLUGIN_INC . '/widgets/text-widget.php');
    require_once(VARAUS_PLUGIN_INC . '/widgets/widget-extra-fields.php');

    // Elementor
    if (file_exists(VARAUS_EM_SHORTCODE_BASE_PATH . '/em-setup.php')) {
      require_once(VARAUS_EM_SHORTCODE_BASE_PATH . '/em-setup.php');
      require_once(VARAUS_EM_SHORTCODE_BASE_PATH . 'lib/fields/icons.php');
      require_once(VARAUS_EM_SHORTCODE_BASE_PATH . 'lib/icons-manager/icons-manager.php');
    }
  }

  add_action('wp_enqueue_scripts', 'varaus_plugin_enqueue_scripts');
  function varaus_plugin_enqueue_scripts()
  {
    wp_enqueue_script('plugin-scripts', VARAUS_PLUGIN_ASTS . '/plugin-scripts.js', array('jquery'), '', true);
  }
}

// Extra functions
require_once(VARAUS_PLUGIN_INC . '/theme-functions.php');
