<?php
/*
 * All Custom Shortcode for [theme_name] theme.
 * Author & Copyright: wpoceans
 * URL: http://themeforest.net/user/wpoceans
 */

if (!function_exists('varaus_shortcodes')) {
  function varaus_shortcodes($options)
  {

    $options       = array();

    /* Topbar Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Topbar Shortcodes', 'varaus'),
      'shortcodes' => array(

        // Topbar item
        array(
          'name'          => 'varaus_widget_topbars',
          'title'         => esc_html__('Topbar info', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_widget_topbar',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'info_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Icon', 'varaus'),
            ),
            array(
              'id'        => 'subtitle',
              'type'      => 'text',
              'title'     => esc_html__('Sub Title', 'varaus'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'varaus'),
            ),
            array(
              'id'        => 'open_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'varaus'),
              'yes'     => esc_html__('Yes', 'varaus'),
              'no'     => esc_html__('No', 'varaus'),
            ),

          ),

        ),


      ),
    );

    /* Header Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Header Shortcodes', 'varaus'),
      'shortcodes' => array(

        // header Social
        array(
          'name'          => 'varaus_header_socials',
          'title'         => esc_html__('Header Social', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_header_social',
          'clone_title'   => esc_html__('Add New Social', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'varaus')
            ),
            array(
              'id'        => 'social_icon_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Color', 'varaus'),
            ),
            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'title'     => esc_html__('Social Link', 'varaus')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'varaus'),
              'yes'     => esc_html__('Yes', 'varaus'),
              'no'     => esc_html__('No', 'varaus'),
            ),

          ),

        ),
        // header Social End

        // header Middle Infos
        array(
          'name'          => 'varaus_header_middle_infos',
          'title'         => esc_html__('Header Middle Info', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_header_middle_info',
          'clone_title'   => esc_html__('Add New Info', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'varaus')
            ),
            array(
              'id'        => 'social_icon_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Color', 'varaus'),
            ),
            array(
              'id'        => 'address_text',
              'type'      => 'text',
              'title'     => esc_html__('Address Text', 'varaus')
            ),
            array(
              'id'        => 'address_desc',
              'type'      => 'text',
              'title'     => esc_html__('Address Details', 'varaus')
            ),
          ),

        ),
        // header Middle Infos End



      ),
    );

    /* Content Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Content Shortcodes', 'varaus'),
      'shortcodes' => array(

        // Spacer
        array(
          'name'          => 'vc_empty_space',
          'title'         => esc_html__('Spacer', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'height',
              'type'      => 'text',
              'title'     => esc_html__('Height', 'varaus'),
              'attributes' => array(
                'placeholder'     => '20px',
              ),
            ),

          ),
        ),
        // Spacer

        // Social Icons
        array(
          'name'          => 'varaus_socials',
          'title'         => esc_html__('Social Icons', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_social',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'section_title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus'),
            ),

            // Colors
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Colors', 'varaus')
            ),
            array(
              'id'        => 'icon_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Color', 'varaus'),
              'wrap_class' => 'column_third',
            ),
            array(
              'id'        => 'icon_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Icon Hover Color', 'varaus'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '!=', 'style-three'),
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Backrgound Color', 'varaus'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '!=', 'style-one'),
            ),
            array(
              'id'        => 'bg_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Backrgound Hover Color', 'varaus'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '==', 'style-two'),
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Color', 'varaus'),
              'wrap_class' => 'column_third',
              'dependency'  => array('social_select', '==', 'style-three'),
            ),

            // Icon Size
            array(
              'id'        => 'icon_size',
              'type'      => 'text',
              'title'     => esc_html__('Icon Size', 'varaus'),
              'wrap_class' => 'column_full',
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => esc_html__('Link', 'varaus')
            ),
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'varaus')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'varaus'),
              'on_text'     => esc_html__('Yes', 'varaus'),
              'off_text'     => esc_html__('No', 'varaus'),
            ),

          ),

        ),
        // Social Icons

        // Useful Links
        array(
          'name'          => 'varaus_useful_links',
          'title'         => esc_html__('Useful Links', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_useful_link',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'column_width',
              'type'      => 'select',
              'title'     => esc_html__('Column Width', 'varaus'),
              'options'        => array(
                'full-width' => esc_html__('One Column', 'varaus'),
                'half-width' => esc_html__('Two Column', 'varaus'),
                'third-width' => esc_html__('Three Column', 'varaus'),
              ),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'title_link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'varaus')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'varaus'),
              'on_text'     => esc_html__('Yes', 'varaus'),
              'off_text'     => esc_html__('No', 'varaus'),
            ),
            array(
              'id'        => 'link_title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus')
            ),

          ),

        ),
        // Useful Links

        // Simple Image List
        array(
          'name'          => 'varaus_image_lists',
          'title'         => esc_html__('Simple Image List', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_image_list',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'get_image',
              'type'      => 'upload',
              'title'     => esc_html__('Image', 'varaus')
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
              'title'     => esc_html__('Link', 'varaus')
            ),
            array(
              'id'    => 'open_tab',
              'type'  => 'switcher',
              'std'   => false,
              'title' => esc_html__('Open link to new tab?', 'varaus')
            ),

          ),

        ),
        // Simple Image List

        // Simple Link
        array(
          'name'          => 'varaus_simple_link',
          'title'         => esc_html__('Simple Link', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'link_style',
              'type'      => 'select',
              'title'     => esc_html__('Link Style', 'varaus'),
              'options'        => array(
                'link-underline' => esc_html__('Link Underline', 'varaus'),
                'link-arrow-right' => esc_html__('Link Arrow (Right)', 'varaus'),
                'link-arrow-left' => esc_html__('Link Arrow (Left)', 'varaus'),
              ),
            ),
            array(
              'id'        => 'link_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Icon', 'varaus'),
              'value'      => 'fa fa-caret-right',
              'dependency'  => array('link_style', '!=', 'link-underline'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => esc_html__('Link Text', 'varaus'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'varaus'),
              'attributes' => array(
                'placeholder'     => 'http://',
              ),
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'varaus'),
              'on_text'     => esc_html__('Yes', 'varaus'),
              'off_text'     => esc_html__('No', 'varaus'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

            // Normal Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Normal Mode', 'varaus')
            ),
            array(
              'id'        => 'text_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Text Color', 'varaus'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Color', 'varaus'),
              'wrap_class' => 'column_half el-hav-border',
              'dependency'  => array('link_style', '==', 'link-underline'),
            ),
            // Hover Mode
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Hover Mode', 'varaus')
            ),
            array(
              'id'        => 'text_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Text Hover Color', 'varaus'),
              'wrap_class' => 'column_half el-hav-border',
            ),
            array(
              'id'        => 'border_hover_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Hover Color', 'varaus'),
              'wrap_class' => 'column_half el-hav-border',
              'dependency'  => array('link_style', '==', 'link-underline'),
            ),

            // Size
            array(
              'type'    => 'notice',
              'class'   => 'info',
              'content' => esc_html__('Font Sizes', 'varaus')
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => esc_html__('Text Size', 'varaus'),
              'attributes' => array(
                'placeholder'     => 'Eg: 14px',
              ),
            ),

          ),
        ),
        // Simple Link

        // Blockquotes
        array(
          'name'          => 'varaus_blockquote',
          'title'         => esc_html__('Blockquote', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'blockquote_style',
              'type'      => 'select',
              'title'     => esc_html__('Blockquote Style', 'varaus'),
              'options'        => array(
                '' => esc_html__('Select Blockquote Style', 'varaus'),
                'style-one' => esc_html__('Style One', 'varaus'),
                'style-two' => esc_html__('Style Two', 'varaus'),
              ),
            ),
            array(
              'id'        => 'text_size',
              'type'      => 'text',
              'title'     => esc_html__('Text Size', 'varaus'),
            ),
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'content_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Content Color', 'varaus'),
            ),
            array(
              'id'        => 'left_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Left Border Color', 'varaus'),
            ),
            array(
              'id'        => 'border_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Border Color', 'varaus'),
            ),
            array(
              'id'        => 'bg_color',
              'type'      => 'color_picker',
              'title'     => esc_html__('Background Color', 'varaus'),
            ),
            // Content
            array(
              'id'        => 'content',
              'type'      => 'textarea',
              'title'     => esc_html__('Content', 'varaus'),
            ),

          ),

        ),
        // Blockquotes

      ),
    );

    /* Widget Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Widget Shortcodes', 'varaus'),
      'shortcodes' => array(

        // widget Contact info
        array(
          'name'          => 'varaus_widget_contact_info',
          'title'         => esc_html__('Contact info', 'varaus'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'image_url',
              'type'      => 'image',
              'title'     => esc_html__('Image background', 'varaus'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus'),
            ),
            array(
              'id'        => 'desc',
              'type'      => 'textarea',
              'title'     => esc_html__('Description', 'varaus'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => esc_html__('Link text', 'varaus'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'varaus'),
            ),

          ),
        ),

        // widget Testimonials
        array(
          'name'          => 'varaus_widget_testimonial',
          'title'         => esc_html__('Testimonial', 'varaus'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'image_url',
              'type'      => 'image',
              'title'     => esc_html__('Image background', 'varaus'),
            ),
            array(
              'id'        => 'subtitle',
              'type'      => 'text',
              'title'     => esc_html__('Sub Title', 'varaus'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus'),
            ),
            array(
              'id'        => 'desc',
              'type'      => 'textarea',
              'title'     => esc_html__('Description', 'varaus'),
            ),

          ),
        ),

        // About widget Block
        array(
          'name'          => 'varaus_about_widget',
          'title'         => esc_html__('About Widget Block', 'varaus'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus'),
            ),
            array(
              'id'        => 'image_url',
              'type'      => 'image',
              'title'     => esc_html__('About Block Image', 'varaus'),
            ),
            array(
              'id'        => 'desc',
              'type'      => 'textarea',
              'title'     => esc_html__('Description', 'varaus'),
            ),
            array(
              'id'        => 'link_text',
              'type'      => 'text',
              'title'     => esc_html__('Link text', 'varaus'),
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Link', 'varaus'),
            ),

          ),
        ),


        // Service Contact Widget
        array(
          'name'          => 'varaus_service_widget_contacts',
          'title'         => esc_html__('Service Feature Widget', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_service_widget_contact',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'contact_title',
              'type'      => 'text',
              'title'     => esc_html__('Title', 'varaus')
            ),
          ),
          'clone_fields'  => array(

            array(
              'id'        => 'info',
              'type'      => 'text',
              'title'     => esc_html__('Contact Info', 'varaus')
            ),

          ),

        ),
        // Service Contact Widget End
        // widget download-widget
        array(
          'name'          => 'varaus_download_widgets',
          'title'         => esc_html__('Download Widget', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_download_widget',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
          ),
          'clone_fields'  => array(

            array(
              'id'        => 'download_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Download Icon', 'varaus')
            ),
            array(
              'id'        => 'title',
              'type'      => 'text',
              'title'     => esc_html__('Download Title', 'varaus')
            ),
            array(
              'id'        => 'link',
              'type'      => 'text',
              'title'     => esc_html__('Download Link', 'varaus')
            ),

          ),

        ),

      ),
    );

    /* Footer Shortcodes */
    $options[]     = array(
      'title'      => esc_html__('Footer Shortcodes', 'varaus'),
      'shortcodes' => array(

        // Footer Menus
        array(
          'name'          => 'varaus_footer_menus',
          'title'         => esc_html__('Footer Menu Links', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_footer_menu',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'menu_title',
              'type'      => 'text',
              'title'     => esc_html__('Menu Title', 'varaus')
            ),
            array(
              'id'        => 'menu_link',
              'type'      => 'text',
              'title'     => esc_html__('Menu Link', 'varaus')
            ),
            array(
              'id'        => 'target_tab',
              'type'      => 'switcher',
              'title'     => esc_html__('Open New Tab?', 'varaus'),
              'on_text'     => esc_html__('Yes', 'varaus'),
              'off_text'     => esc_html__('No', 'varaus'),
            ),

          ),

        ),
        // Footer Menus
        array(
          'name'          => 'footer_infos',
          'title'         => esc_html__('footer logo and Text', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'footer_info',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(
            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'footer_logo',
              'type'      => 'image',
              'title'     => esc_html__('Footer logo', 'varaus'),
            ),
            array(
              'id'        => 'desc',
              'type'      => 'textarea',
              'title'     => esc_html__('Description', 'varaus'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'social_icon',
              'type'      => 'icon',
              'title'     => esc_html__('Social Icon', 'varaus')
            ),
            array(
              'id'        => 'social_link',
              'type'      => 'text',
              'title'     => esc_html__('Social Link', 'varaus')
            ),
          ),

        ),

        // footer contact info
        array(
          'name'          => 'varaus_footer_contact_infos',
          'title'         => esc_html__('Contact info', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_footer_contact_info',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),
            array(
              'id'        => 'title',
              'type'      => 'textarea',
              'title'     => esc_html__('Heading Title', 'varaus'),
            ),

          ),
          'clone_fields'  => array(

            array(
              'id'        => 'item_title',
              'type'      => 'text',
              'title'     => esc_html__('Contact info item title', 'varaus')
            ),
            array(
              'id'        => 'item',
              'type'      => 'text',
              'title'     => esc_html__('Contact info item', 'varaus')
            ),
          ),

        ),

        // footer Address
        array(
          'name'          => 'varaus_footer_address_item',
          'title'         => esc_html__('Address', 'varaus'),
          'view'          => 'clone',
          'clone_id'      => 'varaus_footer_address_items',
          'clone_title'   => esc_html__('Add New', 'varaus'),
          'fields'        => array(

            array(
              'id'        => 'custom_class',
              'type'      => 'text',
              'title'     => esc_html__('Custom Class', 'varaus'),
            ),

          ),
          'clone_fields'  => array(
            array(
              'id'        => 'item',
              'type'      => 'text',
              'title'     => esc_html__('Address item', 'varaus')
            ),
          ),
        ),

      ),
    );

    return $options;
  }
  add_filter('cs_shortcode_options', 'varaus_shortcodes');
}
