<?php

/**
 * Initialize Custom Post Type - Varaus Theme
 */

function varaus_custom_post_type()
{

  $service_cpt = (varaus_framework_active()) ? cs_get_option('theme_service_name') : '';
  $service_slug = (varaus_framework_active()) ? cs_get_option('theme_service_slug') : '';
  $service_cpt_slug = (varaus_framework_active()) ? cs_get_option('theme_service_cat_slug') : '';

  $base = (isset($service_cpt_slug) && $service_cpt_slug !== '') ? sanitize_title_with_dashes($service_cpt_slug) : ((isset($service_cpt) && $service_cpt !== '') ? strtolower($service_cpt) : 'service');
  $base_slug = (isset($service_slug) && $service_slug !== '') ? sanitize_title_with_dashes($service_slug) : ((isset($service_cpt) && $service_cpt !== '') ? strtolower($service_cpt) : 'service');
  $label = ucfirst((isset($service_cpt) && $service_cpt !== '') ? strtolower($service_cpt) : 'service');

  // Register custom post type - Service
  register_post_type(
    'service',
    array(
      'labels' => array(
        'name' => $label,
        'singular_name' => sprintf(esc_html__('%s Post', 'varaus-core'), $label),
        'all_items' => sprintf(esc_html__('All %s', 'varaus-core'), $label),
        'add_new' => esc_html__('Add New', 'varaus-core'),
        'add_new_item' => sprintf(esc_html__('Add New %s', 'varaus-core'), $label),
        'edit' => esc_html__('Edit', 'varaus-core'),
        'edit_item' => sprintf(esc_html__('Edit %s', 'varaus-core'), $label),
        'new_item' => sprintf(esc_html__('New %s', 'varaus-core'), $label),
        'view_item' => sprintf(esc_html__('View %s', 'varaus-core'), $label),
        'search_items' => sprintf(esc_html__('Search %s', 'varaus-core'), $label),
        'not_found' => esc_html__('Nothing found in the Database.', 'varaus-core'),
        'not_found_in_trash' => esc_html__('Nothing found in Trash', 'varaus-core'),
        'parent_item_colon' => ''
      ),
      'public' => true,
      'publicly_queryable' => true,
      'exclude_from_search' => false,
      'show_ui' => true,
      'query_var' => true,
      'menu_position' => 10,
      'menu_icon' => 'dashicons-portfolio',
      'rewrite' => array(
        'slug' => $base_slug,
        'with_front' => false
      ),
      'has_archive' => true,
      'capability_type' => 'post',
      'hierarchical' => true,
      'supports' => array(
        'title',
        'editor',
        'author',
        'thumbnail',
        'excerpt',
        'trackbacks',
        'custom-fields',
        'comments',
        'revisions',
        'sticky',
        'page-attributes'
      )
    )
  );
  // Registered

  // Add Category Taxonomy for our Custom Post Type - Service
  register_taxonomy(
    'service_category',
    'service',
    array(
      'hierarchical' => true,
      'public' => true,
      'show_ui' => true,
      'show_admin_column' => true,
      'show_in_nav_menus' => true,
      'labels' => array(
        'name' => sprintf(esc_html__('%s Categories', 'varaus-core'), $label),
        'singular_name' => sprintf(esc_html__('%s Category', 'varaus-core'), $label),
        'search_items' =>  sprintf(esc_html__('Search %s Categories', 'varaus-core'), $label),
        'all_items' => sprintf(esc_html__('All %s Categories', 'varaus-core'), $label),
        'parent_item' => sprintf(esc_html__('Parent %s Category', 'varaus-core'), $label),
        'parent_item_colon' => sprintf(esc_html__('Parent %s Category:', 'varaus-core'), $label),
        'edit_item' => sprintf(esc_html__('Edit %s Category', 'varaus-core'), $label),
        'update_item' => sprintf(esc_html__('Update %s Category', 'varaus-core'), $label),
        'add_new_item' => sprintf(esc_html__('Add New %s Category', 'varaus-core'), $label),
        'new_item_name' => sprintf(esc_html__('New %s Category Name', 'varaus-core'), $label)
      ),
      'rewrite' => array('slug' => $base . '_cat'),
    )
  );

  $service_custom_taxonomies = (varaus_framework_active()) ? cs_get_option('service_custom_taxonomies') : '';
  $counter = 0;
  if ($service_custom_taxonomies) {
    foreach ($service_custom_taxonomies as $key => $custom_taxonomy) {
      $counter++;
      $heading = $custom_taxonomy['taxonomy_name'];
      $own_id = preg_replace('/[^a-z]/', "_", strtolower($heading));

      register_taxonomy(
        'service_' . $own_id,
        'service',
        array(
          'hierarchical' => true,
          'public' => true,
          'show_ui' => true,
          'show_admin_column' => true,
          'show_in_nav_menus' => true,
          'labels' => array(
            'name' => sprintf(esc_html__('%s ' . $heading, 'varaus-core'), $label),
            'singular_name' => sprintf(esc_html__('%s ' . $heading, 'varaus-core'), $label),
            'search_items' =>  sprintf(esc_html__('Search %s ' . $heading, 'varaus-core'), $label),
            'all_items' => sprintf(esc_html__('All %s ' . $heading, 'varaus-core'), $label),
            'parent_item' => sprintf(esc_html__('Parent %s ' . $heading, 'varaus-core'), $label),
            'parent_item_colon' => sprintf(esc_html__('Parent %s :.$heading', 'varaus-core'), $label),
            'edit_item' => sprintf(esc_html__('Edit %s ' . $heading, 'varaus-core'), $label),
            'update_item' => sprintf(esc_html__('Update %s ' . $heading, 'varaus-core'), $label),
            'add_new_item' => sprintf(esc_html__('Add New %s ' . $heading, 'varaus-core'), $label),
            'new_item_name' => sprintf(esc_html__('New %s ' . $heading . ' Name', 'varaus-core'), $label)
          ),
          'rewrite' => array('slug' => 'service_' . $own_id),
        )
      );
    }
  }


  // Destination Start

  $destination_cpt = (varaus_framework_active()) ? cs_get_option('theme_destination_name') : '';
  $destination_slug = (varaus_framework_active()) ? cs_get_option('theme_destination_slug') : '';
  $destination_cpt_slug = (varaus_framework_active()) ? cs_get_option('theme_destination_cat_slug') : '';

  $base = (isset($destination_cpt_slug) && $destination_cpt_slug !== '') ? sanitize_title_with_dashes($destination_cpt_slug) : ((isset($destination_cpt) && $destination_cpt !== '') ? strtolower($destination_cpt) : 'destination');
  $base_slug = (isset($destination_slug) && $destination_slug !== '') ? sanitize_title_with_dashes($destination_slug) : ((isset($destination_cpt) && $destination_cpt !== '') ? strtolower($destination_cpt) : 'destination');
  $label = ucfirst((isset($destination_cpt) && $destination_cpt !== '') ? strtolower($destination_cpt) : 'destination');

  // Register custom post type - Destination
  register_post_type(
    'destination',
    array(
      'labels' => array(
        'name' => $label,
        'singular_name' => sprintf(esc_html__('%s Post', 'varaus-core'), $label),
        'all_items' => sprintf(esc_html__('All %s', 'varaus-core'), $label),
        'add_new' => esc_html__('Add New', 'varaus-core'),
        'add_new_item' => sprintf(esc_html__('Add New %s', 'varaus-core'), $label),
        'edit' => esc_html__('Edit', 'varaus-core'),
        'edit_item' => sprintf(esc_html__('Edit %s', 'varaus-core'), $label),
        'new_item' => sprintf(esc_html__('New %s', 'varaus-core'), $label),
        'view_item' => sprintf(esc_html__('View %s', 'varaus-core'), $label),
        'search_items' => sprintf(esc_html__('Search %s', 'varaus-core'), $label),
        'not_found' => esc_html__('Nothing found in the Database.', 'varaus-core'),
        'not_found_in_trash' => esc_html__('Nothing found in Trash', 'varaus-core'),
        'parent_item_colon' => ''
      ),
      'public' => true,
      'publicly_queryable' => true,
      'exclude_from_search' => false,
      'show_ui' => true,
      'query_var' => true,
      'menu_position' => 10,
      'menu_icon' => 'dashicons-portfolio',
      'rewrite' => array(
        'slug' => $base_slug,
        'with_front' => false
      ),
      'has_archive' => true,
      'capability_type' => 'post',
      'hierarchical' => true,
      'supports' => array(
        'title',
        'editor',
        'author',
        'thumbnail',
        'excerpt',
        'trackbacks',
        'custom-fields',
        'comments',
        'revisions',
        'sticky',
        'page-attributes'
      )
    )
  );
  // Registered

  // Add Category Taxonomy for our Custom Post Type - Destination
  register_taxonomy(
    'destination_category',
    'destination',
    array(
      'hierarchical' => true,
      'public' => true,
      'show_ui' => true,
      'show_admin_column' => true,
      'show_in_nav_menus' => true,
      'labels' => array(
        'name' => sprintf(esc_html__('%s Categories', 'varaus-core'), $label),
        'singular_name' => sprintf(esc_html__('%s Category', 'varaus-core'), $label),
        'search_items' =>  sprintf(esc_html__('Search %s Categories', 'varaus-core'), $label),
        'all_items' => sprintf(esc_html__('All %s Categories', 'varaus-core'), $label),
        'parent_item' => sprintf(esc_html__('Parent %s Category', 'varaus-core'), $label),
        'parent_item_colon' => sprintf(esc_html__('Parent %s Category:', 'varaus-core'), $label),
        'edit_item' => sprintf(esc_html__('Edit %s Category', 'varaus-core'), $label),
        'update_item' => sprintf(esc_html__('Update %s Category', 'varaus-core'), $label),
        'add_new_item' => sprintf(esc_html__('Add New %s Category', 'varaus-core'), $label),
        'new_item_name' => sprintf(esc_html__('New %s Category Name', 'varaus-core'), $label)
      ),
      'rewrite' => array('slug' => $base . '_cat'),
    )
  );

  $destination_custom_taxonomies = (varaus_framework_active()) ? cs_get_option('destination_custom_taxonomies') : '';
  $counter = 0;
  if ($destination_custom_taxonomies) {
    foreach ($destination_custom_taxonomies as $key => $custom_taxonomy) {
      $counter++;
      $heading = $custom_taxonomy['taxonomy_name'];
      $own_id = preg_replace('/[^a-z]/', "_", strtolower($heading));

      register_taxonomy(
        'destination_' . $own_id,
        'destination',
        array(
          'hierarchical' => true,
          'public' => true,
          'show_ui' => true,
          'show_admin_column' => true,
          'show_in_nav_menus' => true,
          'labels' => array(
            'name' => sprintf(esc_html__('%s ' . $heading, 'varaus-core'), $label),
            'singular_name' => sprintf(esc_html__('%s ' . $heading, 'varaus-core'), $label),
            'search_items' =>  sprintf(esc_html__('Search %s ' . $heading, 'varaus-core'), $label),
            'all_items' => sprintf(esc_html__('All %s ' . $heading, 'varaus-core'), $label),
            'parent_item' => sprintf(esc_html__('Parent %s ' . $heading, 'varaus-core'), $label),
            'parent_item_colon' => sprintf(esc_html__('Parent %s :.$heading', 'varaus-core'), $label),
            'edit_item' => sprintf(esc_html__('Edit %s ' . $heading, 'varaus-core'), $label),
            'update_item' => sprintf(esc_html__('Update %s ' . $heading, 'varaus-core'), $label),
            'add_new_item' => sprintf(esc_html__('Add New %s ' . $heading, 'varaus-core'), $label),
            'new_item_name' => sprintf(esc_html__('New %s ' . $heading . ' Name', 'varaus-core'), $label)
          ),
          'rewrite' => array('slug' => 'destination_' . $own_id),
        )
      );
    }
  }




  // Team Start

  $team_cpt = (varaus_framework_active()) ? cs_get_option('theme_team_name') : '';
  $team_slug = (varaus_framework_active()) ? cs_get_option('theme_team_slug') : '';
  $team_cpt_slug = (varaus_framework_active()) ? cs_get_option('theme_team_cat_slug') : '';

  $base = (isset($team_cpt_slug) && $team_cpt_slug !== '') ? sanitize_title_with_dashes($team_cpt_slug) : ((isset($team_cpt) && $team_cpt !== '') ? strtolower($team_cpt) : 'team');
  $base_slug = (isset($team_slug) && $team_slug !== '') ? sanitize_title_with_dashes($team_slug) : ((isset($team_cpt) && $team_cpt !== '') ? strtolower($team_cpt) : 'team');
  $label = ucfirst((isset($team_cpt) && $team_cpt !== '') ? strtolower($team_cpt) : 'team');

  // Register custom post type - Team
  register_post_type(
    'team',
    array(
      'labels' => array(
        'name' => $label,
        'singular_name' => sprintf(esc_html__('%s Post', 'varaus-core'), $label),
        'all_items' => sprintf(esc_html__('All %s', 'varaus-core'), $label),
        'add_new' => esc_html__('Add New', 'varaus-core'),
        'add_new_item' => sprintf(esc_html__('Add New %s', 'varaus-core'), $label),
        'edit' => esc_html__('Edit', 'varaus-core'),
        'edit_item' => sprintf(esc_html__('Edit %s', 'varaus-core'), $label),
        'new_item' => sprintf(esc_html__('New %s', 'varaus-core'), $label),
        'view_item' => sprintf(esc_html__('View %s', 'varaus-core'), $label),
        'search_items' => sprintf(esc_html__('Search %s', 'varaus-core'), $label),
        'not_found' => esc_html__('Nothing found in the Database.', 'varaus-core'),
        'not_found_in_trash' => esc_html__('Nothing found in Trash', 'varaus-core'),
        'parent_item_colon' => ''
      ),
      'public' => true,
      'publicly_queryable' => true,
      'exclude_from_search' => false,
      'show_ui' => true,
      'query_var' => true,
      'menu_position' => 10,
      'menu_icon' => 'dashicons-portfolio',
      'rewrite' => array(
        'slug' => $base_slug,
        'with_front' => false
      ),
      'has_archive' => true,
      'capability_type' => 'post',
      'hierarchical' => true,
      'supports' => array(
        'title',
        'editor',
        'author',
        'thumbnail',
        'excerpt',
        'trackbacks',
        'custom-fields',
        'comments',
        'revisions',
        'sticky',
        'page-attributes'
      )
    )
  );
  // Registered

  // Add Category Taxonomy for our Custom Post Type - Team
  register_taxonomy(
    'team_category',
    'team',
    array(
      'hierarchical' => true,
      'public' => true,
      'show_ui' => true,
      'show_admin_column' => true,
      'show_in_nav_menus' => true,
      'labels' => array(
        'name' => sprintf(esc_html__('%s Categories', 'varaus-core'), $label),
        'singular_name' => sprintf(esc_html__('%s Category', 'varaus-core'), $label),
        'search_items' =>  sprintf(esc_html__('Search %s Categories', 'varaus-core'), $label),
        'all_items' => sprintf(esc_html__('All %s Categories', 'varaus-core'), $label),
        'parent_item' => sprintf(esc_html__('Parent %s Category', 'varaus-core'), $label),
        'parent_item_colon' => sprintf(esc_html__('Parent %s Category:', 'varaus-core'), $label),
        'edit_item' => sprintf(esc_html__('Edit %s Category', 'varaus-core'), $label),
        'update_item' => sprintf(esc_html__('Update %s Category', 'varaus-core'), $label),
        'add_new_item' => sprintf(esc_html__('Add New %s Category', 'varaus-core'), $label),
        'new_item_name' => sprintf(esc_html__('New %s Category Name', 'varaus-core'), $label)
      ),
      'rewrite' => array('slug' => $base . '_cat'),
    )
  );

  $team_custom_taxonomies = (varaus_framework_active()) ? cs_get_option('team_custom_taxonomies') : '';
  $counter = 0;
  if ($team_custom_taxonomies) {
    foreach ($team_custom_taxonomies as $key => $custom_taxonomy) {
      $counter++;
      $heading = $custom_taxonomy['taxonomy_name'];
      $own_id = preg_replace('/[^a-z]/', "_", strtolower($heading));

      register_taxonomy(
        'team_' . $own_id,
        'team',
        array(
          'hierarchical' => true,
          'public' => true,
          'show_ui' => true,
          'show_admin_column' => true,
          'show_in_nav_menus' => true,
          'labels' => array(
            'name' => sprintf(esc_html__('%s ' . $heading, 'varaus-core'), $label),
            'singular_name' => sprintf(esc_html__('%s ' . $heading, 'varaus-core'), $label),
            'search_items' =>  sprintf(esc_html__('Search %s ' . $heading, 'varaus-core'), $label),
            'all_items' => sprintf(esc_html__('All %s ' . $heading, 'varaus-core'), $label),
            'parent_item' => sprintf(esc_html__('Parent %s ' . $heading, 'varaus-core'), $label),
            'parent_item_colon' => sprintf(esc_html__('Parent %s :.$heading', 'varaus-core'), $label),
            'edit_item' => sprintf(esc_html__('Edit %s ' . $heading, 'varaus-core'), $label),
            'update_item' => sprintf(esc_html__('Update %s ' . $heading, 'varaus-core'), $label),
            'add_new_item' => sprintf(esc_html__('Add New %s ' . $heading, 'varaus-core'), $label),
            'new_item_name' => sprintf(esc_html__('New %s ' . $heading . ' Name', 'varaus-core'), $label)
          ),
          'rewrite' => array('slug' => 'team_' . $own_id),
        )
      );
    }
  }
}




// After Theme Setup
function varaus_custom_flush_rules()
{
  // Enter post type function, so rewrite work within this function
  varaus_custom_post_type();
  // Flush it
  flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'varaus_custom_flush_rules');
add_action('init', 'varaus_custom_post_type');


/* ---------------------------------------------------------------------------
 * Custom columns - Service
 * --------------------------------------------------------------------------- */
add_filter("manage_edit-service_columns", "varaus_service_edit_columns");
function varaus_service_edit_columns($columns)
{
  $new_columns['cb'] = '<input type="checkbox" />';
  $new_columns['title'] = esc_html__('Title', 'varaus-core');
  $new_columns['thumbnail'] = esc_html__('Image', 'varaus-core');
  $new_columns['date'] = esc_html__('Date', 'varaus-core');

  return $new_columns;
}

add_action('manage_service_posts_custom_column', 'varaus_manage_service_columns', 10, 2);
function varaus_manage_service_columns($column_name)
{
  global $post;

  switch ($column_name) {

      /* If displaying the 'Image' column. */
    case 'thumbnail':
      echo get_the_post_thumbnail($post->ID, array(100, 100));
      break;

      /* Just break out of the switch statement for everything else. */
    default:
      break;
      break;
  }
}


/* ---------------------------------------------------------------------------
 * Custom columns - case
 * --------------------------------------------------------------------------- */
add_filter("manage_edit-destination_columns", "varaus_destination_edit_columns");
function varaus_destination_edit_columns($columns)
{
  $new_columns['cb'] = '<input type="checkbox" />';
  $new_columns['title'] = esc_html__('Title', 'varaus-core');
  $new_columns['thumbnail'] = esc_html__('Image', 'varaus-core');
  $new_columns['date'] = esc_html__('Date', 'varaus-core');

  return $new_columns;
}

add_action('manage_destination_posts_custom_column', 'varaus_manage_destination_columns', 10, 2);
function varaus_manage_destination_columns($column_name)
{
  global $post;

  switch ($column_name) {

      /* If displaying the 'Image' column. */
    case 'thumbnail':
      echo get_the_post_thumbnail($post->ID, array(100, 100));
      break;

      /* Just break out of the switch statement for everything else. */
    default:
      break;
      break;
  }
}


// Team Slug
function varaus_custom_team_slug()
{
  $team_cpt = (varaus_framework_active()) ? cs_get_option('theme_team_name') : '';
  if ($team_cpt === '') $team_cp = 'team';
  $rules = get_option('rewrite_rules');
  if (!isset($rules['(' . $team_cpt . ')/(\d*)$'])) {
    global $wp_rewrite;
    $wp_rewrite->flush_rules();
  }
}
add_action('cs_validate_save_after', 'varaus_custom_team_slug');


// Avoid team post type as 404 page while it change
function thx_cpt_avoid_error_team()
{
  $team_cpt = (varaus_framework_active()) ? cs_get_option('theme_team_name') : '';
  if ($team_cpt === '') $team_cp = 'team';
  $set = get_option('post_type_rules_flased_' . $team_cpt);
  if ($set !== true) {
    flush_rewrite_rules(false);
    update_option('post_type_rules_flased_' . $team_cpt, true);
  }
}
add_action('init', 'thx_cpt_avoid_error_team');

// Add Filter by Category in Team Type
add_action('restrict_manage_posts', 'varaus_filter_team_categories');
function varaus_filter_team_categories()
{
  global $typenow;
  $post_type = 'team'; // Team post type
  $taxonomy  = 'team_category'; // Team category taxonomy
  if ($typenow == $post_type) {
    $selected      = isset($_GET[$taxonomy]) ? $_GET[$taxonomy] : '';
    $info_taxonomy = get_taxonomy($taxonomy);
    wp_dropdown_categories(array(
      'show_option_all' => sprintf(esc_html__("Show All %s", 'varaus-core'), $info_taxonomy->label),
      'taxonomy'        => $taxonomy,
      'name'            => $taxonomy,
      'orderby'         => 'name',
      'selected'        => $selected,
      'show_count'      => true,
      'hide_empty'      => true,
    ));
  };
}

// Team Search => ID to Term
add_filter('parse_query', 'varaus_team_id_term_search');
function varaus_team_id_term_search($query)
{
  global $pagenow;
  $post_type = 'team'; // Team post type
  $taxonomy  = 'team_category'; // Team category taxonomy
  $q_vars    = &$query->query_vars;
  if ($pagenow == 'edit.php' && isset($q_vars['post_type']) && $q_vars['post_type'] == $post_type && isset($q_vars[$taxonomy]) && is_numeric($q_vars[$taxonomy]) && $q_vars[$taxonomy] != 0) {
    $term = get_term_by('id', $q_vars[$taxonomy], $taxonomy);
    $q_vars[$taxonomy] = $term->slug;
  }
}

/* ---------------------------------------------------------------------------
 * Custom columns - Team
 * --------------------------------------------------------------------------- */
add_filter("manage_edit-team_columns", "varaus_team_edit_columns");
function varaus_team_edit_columns($columns)
{
  $new_columns['cb'] = '<input type="checkbox" />';
  $new_columns['title'] = __('Title', 'varaus-core');
  $new_columns['thumbnail'] = __('Image', 'varaus-core');
  $new_columns['team_category'] = __('Categories', 'varaus-core');
  $new_columns['team_order'] = __('Order', 'varaus-core');
  $new_columns['date'] = __('Date', 'varaus-core');

  return $new_columns;
}
add_action('manage_team_posts_custom_column', 'varaus_manage_team_columns', 10, 2);
function varaus_manage_team_columns($column_name)
{
  global $post;

  switch ($column_name) {

      /* If displaying the 'Image' column. */
    case 'thumbnail':
      echo get_the_post_thumbnail($post->ID, array(100, 100));
      break;

      /* If displaying the 'Categories' column. */
    case 'team_category':

      $terms = get_the_terms($post->ID, 'team_category');

      if (!empty($terms)) {

        $out = array();
        foreach ($terms as $term) {
          $out[] = sprintf(
            '<a href="%s">%s</a>',
            esc_url(add_query_arg(array('post_type' => $post->post_type, 'team_category' => $term->slug), 'edit.php')),
            esc_html(sanitize_term_field('name', $term->name, $term->term_id, 'team_category', 'display'))
          );
        }
        /* Join the terms, separating them with a comma. */
        echo join(', ', $out);
      }

      /* If no terms were found, output a default message. */ else {
        echo '&macr;';
      }

      break;

    case "team_order":
      echo $post->menu_order;
      break;

      /* Just break out of the switch statement for everything else. */
    default:
      break;
      break;
  }
}
