<?php
/*
 * Elementor Varaus Title Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_Title extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_title';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Title', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-heading';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus Title widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	/*
	public function get_script_depends() {
		return ['tmx-varaus_title'];
	}
	*/

	/**
	 * Register Varaus Title widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_Title',
			[
				'label' => esc_html__('Title Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'title_style',
			[
				'label' => esc_html__('Title Style', 'varaus-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style-one' => esc_html__('Style One', 'varaus-core'),
					'style-two' => esc_html__('Style Two', 'varaus-core'),
				],
				'default' => 'style-one',
				'description' => esc_html__('Select your Title style.', 'varaus-core'),
			]
		);
		$this->add_control(
			'title_icon',
			[
				'label' => __('Icon', 'varaus-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => [
					'title_style' => array('style-one'),
				],
				'default' => [
					'value' => 'fi flaticon-suitcase',
					'library' => 'solid',

				],
			]
		);
		$this->add_control(
			'section_subtitle',
			[
				'label' => esc_html__('Sub Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Sub Text', 'varaus-core'),
				'placeholder' => esc_html__('Type sub title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_content',
			[
				'label' => esc_html__('Title Content', 'varaus-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Title Content', 'varaus-core'),
				'placeholder' => esc_html__('Type title content here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_responsive_control(
			'content_min_width',
			[
				'label' => esc_html__('Width', 'varaus-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 350,
						'max' => 750,
						'step' => 1,
					],
				],
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .section-title-s3 p' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'title_style' => array('style-one'),
				],
			]
		);
		$this->end_controls_section(); // end: Section

		//Icon

		$this->start_controls_section(
			'title_section_icon_style',
			[
				'label' => esc_html__('Icon', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'title_style' => array('style-one'),
				],
			]
		);
		$this->add_control(
			'title_icon_color',
			[
				'label' => esc_html__('Icon Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title-area .section-title-s3 .icon .fi:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_icon_border_color',
			[
				'label' => esc_html__('Icon Border Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .asection-title-area .section-title-s3 .icon' => 'box-shadow: 0 0 0 5px {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_icon_bg_color',
			[
				'label' => esc_html__('Icon Background Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title-area .section-title-s3 .icon' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section(); // end: Section

		// Sub Title
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__('Sub Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'varaus_subtitle_typography',
				'selector' => '{{WRAPPER}} .section-title span,.section-title-s3 span',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title span,.section-title-s3 span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_padding',
			[
				'label' => __('Sub Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .section-title span,.section-title-s3 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'varaus_title_typography',
				'selector' => '{{WRAPPER}} .section-title h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => __('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .section-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__('Content', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'varaus_content_typography',
				'selector' => '{{WRAPPER}} .section-title p,.section-title-area .text p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .section-title p,.section-title-area .text p,.section-title-s3 p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'content_padding',
			[
				'label' => __('Content Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .section-title p,.section-title-area .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render Title widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();

		$title_style = !empty($settings['title_style']) ? $settings['title_style'] : '';
		$title_icon = !empty($settings['title_icon']['value']) ? $settings['title_icon']['value'] : '';
		$section_subtitle = !empty($settings['section_subtitle']) ? $settings['section_subtitle'] : '';
		$section_title = !empty($settings['section_title']) ? $settings['section_title'] : '';
		$section_content = !empty($settings['section_content']) ? $settings['section_content'] : '';

		// Turn output buffer on

		ob_start();

		if ($title_style === 'style-two') { ?>
			<div class="section-title-area">
				<div class="row">
					<div class="col col-md-6">
						<div class="section-title section-title-s2">
							<?php
							if ($section_subtitle) {
								echo '<span>' . wp_kses_post($section_subtitle) . '</span>';
							}
							if ($section_title) {
								echo '<h2>' . esc_html($section_title) . '</h2>';
							}
							?>
						</div>
					</div>
					<div class="col col-md-6">
						<div class="text">
							<?php
							if ($section_content) {
								echo '<p>' . esc_html($section_content) . '</p>';
							}
							?>
						</div>
					</div>
				</div>
			</div>
		<?php } else { ?>
			<div class="col col-lg-6 col-lg-offset-3 col-md-8 col-md-offset-2 col-sm-10 col-sm-offset-1">
				<div class="section-title-s3">
					<?php
					if ($title_icon) { ?>
						<div class="icon">
							<?php if ($title_icon) {
								echo '<i class="fi ' . esc_attr($title_icon) . '"></i>';
							}  ?>
						</div>
					<?php }
					if ($section_subtitle) {
						echo '<span>' . wp_kses_post($section_subtitle) . '</span>';
					}
					if ($section_title) {
						echo '<h2>' . esc_html($section_title) . '</h2>';
					}
					if ($section_content) {
						echo '<p>' . esc_html($section_content) . '</p>';
					}
					?>
				</div>
			</div>
<?php }

		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Title widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_Title());
