<?php
/*
 * Elementor Varaus Testimonial Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_Testimonial extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_testimonial';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Testimonial', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-testimonial';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus Testimonial widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_testimonial'];
	}

	/**
	 * Register Varaus Testimonial widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_testimonial',
			[
				'label' => esc_html__('Testimonial Options', 'varaus-core'),
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'review_image',
			[
				'label' => esc_html__('Review Image', 'varaus-core'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],

			]
		);
		$repeater->add_control(
			'testimonial_title',
			[
				'label' => esc_html__('Testimonial Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'testimonial_subtitle',
			[
				'label' => esc_html__('Testimonial Sub Title', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Testimonial Sub Title', 'varaus-core'),
				'placeholder' => esc_html__('Type testimonial Sub title here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'testimonial_content',
			[
				'label' => esc_html__('Testimonial Content', 'varaus-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Testimonial Content', 'varaus-core'),
				'placeholder' => esc_html__('Type testimonial Content here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__('Testimonial Image', 'varaus-core'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],

			]
		);
		$this->add_control(
			'testimonialItems_groups',
			[
				'label' => esc_html__('Testimonial Items', 'varaus-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'testimonial_title' => esc_html__('Testimonial', 'varaus-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ testimonial_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section

		// Testimonial Content Style 
		$this->start_controls_section(
			'testimonials_section_content_style',
			[
				'label' => esc_html__('Testimonial Content', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'testimonials_varaus_content_typography',
				'selector' => '{{WRAPPER}} .testimonial-slider .quote p',
			]
		);
		$this->add_control(
			'testimonials_content_color',
			[
				'label' => esc_html__('Content Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider .quote p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'testimonials_content_bg_color',
			[
				'label' => esc_html__('BG Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider .grid' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'testimonials_content_br_color',
			[
				'label' => esc_html__('Border Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider .grid' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Testimonial Name Style 
		$this->start_controls_section(
			'testimonials_section_name_style',
			[
				'label' => esc_html__('Testimonial Name', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'testimonials_varaus_name_typography',
				'selector' => '{{WRAPPER}} .testimonial-slider .client-text h5',
			]
		);
		$this->add_control(
			'testimonials_name_color',
			[
				'label' => esc_html__('Name Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider .client-text h5' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Testimonial Title Style 
		$this->start_controls_section(
			'testimonials_section_title_style',
			[
				'label' => esc_html__('Testimonial Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'testimonials_varaus_title_typography',
				'selector' => '{{WRAPPER}} .testimonial-slider .client-text p',
			]
		);
		$this->add_control(
			'testimonials_title_color',
			[
				'label' => esc_html__('Name Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider .client-text p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

	}

	/**
	 * Render Testimonial widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$testimonialItems_groups = !empty($settings['testimonialItems_groups']) ? $settings['testimonialItems_groups'] : [];

		// Turn output buffer on
		ob_start(); ?>
		<div class="testimonial-area">
			<div class="testimonial-slider clearfix">
				<?php 	// Group Param Output
				if (is_array($testimonialItems_groups) && !empty($testimonialItems_groups)) {
					foreach ($testimonialItems_groups as $each_items) {

						$testimonial_title = !empty($each_items['testimonial_title']) ? $each_items['testimonial_title'] : '';
						$testimonial_subtitle = !empty($each_items['testimonial_subtitle']) ? $each_items['testimonial_subtitle'] : '';
						$testimonial_content = !empty($each_items['testimonial_content']) ? $each_items['testimonial_content'] : '';

						$image_url = wp_get_attachment_url($each_items['bg_image']['id']);
						$image_alt = get_post_meta($each_items['bg_image']['id'], '_wp_attachment_image_alt', true);

						$review_url = wp_get_attachment_url($each_items['review_image']['id']);
						$review_alt = get_post_meta($each_items['review_image']['id'], '_wp_attachment_image_alt', true);
				?>
						<div class="grid">
							<div class="ratting">
								<?php if ($review_url) {
									echo '<img src="' . esc_url($review_url) . '" alt="' . esc_attr($review_alt) . '">';
								} ?>
							</div>
							<div class="quote">
								<?php if ($testimonial_content) {
									echo '<p>' . esc_html($testimonial_content) . '</p>';
								} ?>
							</div>
							<div class="client-info">
								<div class="client-img">
									<?php if ($image_url) {
										echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($image_alt) . '">';
									} ?>
								</div>
								<div class="client-text">
									<?php
									if ($testimonial_title) {
										echo '<h5>' . esc_html($testimonial_title) . '</h5>';
									}
									if ($testimonial_subtitle) {
										echo '<p>' . esc_html($testimonial_subtitle) . '</p>';
									}
									?>
								</div>
							</div>
						</div>
				<?php }
				} ?>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Testimonial widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_Testimonial());
