<?php
/*
 * Elementor Varaus Destination Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_Destination extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_destination';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Destination', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-posts-grid';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus Destination widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_destination'];
	}

	/**
	 * Register Varaus Destination widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{


		$posts = get_posts('post_type="destination"&numberposts=-1');
		$PostID = array();
		if ($posts) {
			foreach ($posts as $post) {
				$PostID[$post->ID] = $post->ID;
			}
		} else {
			$PostID[__('No ID\'s found', 'varaus')] = 0;
		}


		$this->start_controls_section(
			'section_destination',
			[
				'label' => esc_html__('Destination Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'destination_style',
			[
				'label' => esc_html__('Destination Style', 'varaus-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style-one' => esc_html__('Style One', 'varaus-core'),
					'style-two' => esc_html__('Style Two', 'varaus-core'),
					'style-three' => esc_html__('Style Three', 'varaus-core'),
				],
				'default' => 'style-one',
				'description' => esc_html__('Select your destination style.', 'varaus-core'),
			]
		);
		$this->end_controls_section(); // end: Section


		$this->start_controls_section(
			'section_destination_listing',
			[
				'label' => esc_html__('Listing Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'destination_limit',
			[
				'label' => esc_html__('Destination Limit', 'varaus-core'),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 3,
				'description' => esc_html__('Enter the number of items to show.', 'varaus-core'),
			]
		);
		$this->add_control(
			'destination_order',
			[
				'label' => __('Order', 'varaus-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => esc_html__('Asending', 'varaus-core'),
					'DESC' => esc_html__('Desending', 'varaus-core'),
				],
				'default' => 'DESC',
			]
		);
		$this->add_control(
			'destination_orderby',
			[
				'label' => __('Order By', 'varaus-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__('None', 'varaus-core'),
					'ID' => esc_html__('ID', 'varaus-core'),
					'author' => esc_html__('Author', 'varaus-core'),
					'title' => esc_html__('Title', 'varaus-core'),
					'date' => esc_html__('Date', 'varaus-core'),
				],
				'default' => 'date',
			]
		);
		$this->add_control(
			'destination_show_category',
			[
				'label' => __('Certain Categories?', 'varaus-core'),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => Controls_Helper_Output::get_terms_names('destination_category'),
				'multiple' => true,
			]
		);
		$this->add_control(
			'destination_show_id',
			[
				'label' => __('Certain ID\'s?', 'varaus-core'),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => $PostID,
				'multiple' => true,
			]
		);
		$this->add_control(
			'read_more_txt',
			[
				'label' => esc_html__('Read More Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__('Type your Read More text here', 'varaus-core'),
			]
		);
		$this->add_control(
			'destination_content',
			[
				'label' => esc_html__('Desctription', 'varaus-core'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'varaus-core'),
				'label_off' => esc_html__('Hide', 'varaus-core'),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'destination_more',
			[
				'label' => esc_html__('Read More', 'varaus-core'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'varaus-core'),
				'label_off' => esc_html__('Hide', 'varaus-core'),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->end_controls_section(); // end: Section

		// Overly
		$this->start_controls_section(
			'section_overly_style',
			[
				'label' => esc_html__('Content Area', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'label' => esc_html__('Background', 'varaus-core'),
				'description' => esc_html__('Destination Color', 'varaus-core'),
				'types' => ['gradient', 'classic'],
				'selector' => '{{WRAPPER}} .varaus-destination .destination-content',
			]
		);
		$this->end_controls_section(); // end: Section


		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_title_typography',
				'selector' => '{{WRAPPER}} .varaus-destination .destination-content .content-left h5',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-destination .destination-content .content-left h5 a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .varaus-destination .destination-content .content-left h5' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Date
		$this->start_controls_section(
			'section_date_style',
			[
				'label' => esc_html__('Date', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_date_typography',
				'selector' => '{{WRAPPER}} .varaus-destination .destination-content .content-left small',
			]
		);
		$this->add_control(
			'date_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-destination .destination-content .content-left small' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'date_padding',
			[
				'label' => esc_html__('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .varaus-destination .destination-content .content-left small' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Price
		$this->start_controls_section(
			'section_price_style',
			[
				'label' => esc_html__('Price', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_price_typography',
				'selector' => '{{WRAPPER}} .varaus-destination .destination-content .content-right h5',
			]
		);
		$this->add_control(
			'price_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-destination .content-right h5' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Day
		$this->start_controls_section(
			'section_days_style',
			[
				'label' => esc_html__('Day', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_days_typography',
				'selector' => '{{WRAPPER}} .varaus-destination .destination-content .content-right span',
			]
		);
		$this->add_control(
			'days_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-destination .content-right span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section



	}

	/**
	 * Render Destination widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$destination_style = !empty($settings['destination_style']) ? $settings['destination_style'] : '';

		$destination_limit = !empty($settings['destination_limit']) ? $settings['destination_limit'] : '';
		$destination_order = !empty($settings['destination_order']) ? $settings['destination_order'] : '';
		$destination_orderby = !empty($settings['destination_orderby']) ? $settings['destination_orderby'] : '';
		$destination_show_category = !empty($settings['destination_show_category']) ? $settings['destination_show_category'] : [];
		$destination_show_id = !empty($settings['destination_show_id']) ? $settings['destination_show_id'] : [];
		$read_more_txt = !empty($settings['read_more_txt']) ? $settings['read_more_txt'] : '';

		$destination_more = !empty($settings['destination_more']) ? $settings['destination_more'] : [];
		$destination_content = !empty($settings['destination_content']) ? $settings['destination_content'] : [];

		$read_more_txt = $read_more_txt ? $read_more_txt : esc_html__('Read More', 'varaus-core');


		// Turn output buffer on
		ob_start();

		// Pagination
		global $paged;
		if (get_query_var('paged'))
			$my_page = get_query_var('paged');
		else {
			if (get_query_var('page'))
				$my_page = get_query_var('page');
			else
				$my_page = 1;
			set_query_var('paged', $my_page);
			$paged = $my_page;
		}

		if ($destination_show_id) {
			$destination_show_id = json_encode($destination_show_id);
			$destination_show_id = str_replace(array('[', ']'), '', $destination_show_id);
			$destination_show_id = str_replace(array('"', '"'), '', $destination_show_id);
			$destination_show_id = explode(',', $destination_show_id);
		} else {
			$destination_show_id = '';
		}

		$args = array(
			// other query params here,
			'paged' => $my_page,
			'post_type' => 'destination',
			'posts_per_page' => (int)$destination_limit,
			'destination_category' => implode(',', $destination_show_category),
			'orderby' => $destination_orderby,
			'order' => $destination_order,
			'post__in' => $destination_show_id,
		);

		$varaus_destination = new \WP_Query($args);

		if ($destination_style === 'style-one') {
			$destination_wrap = 'destination-area';
			$destination_col = 'destination-wrap';
		} else {
			$destination_wrap = 'destination-service';
			$destination_col = 'destination-carousel owl-carousel owl-theme';
		}

		if ($destination_style === 'style-three') { ?>
			<div class="varaus-desst-section">
				<div class="varaus-desst-grids">
					<?php
					if ($varaus_destination->have_posts()) : while ($varaus_destination->have_posts()) : $varaus_destination->the_post();

							$destination_options = get_post_meta(get_the_ID(), 'destination_options', true);
							$destination_title = isset($destination_options['destination_title']) ? $destination_options['destination_title'] : '';
							$destination_date = isset($destination_options['destination_date']) ? $destination_options['destination_date'] : '';
							$destination_days = isset($destination_options['destination_days']) ? $destination_options['destination_days'] : '';
							$destination_price = isset($destination_options['destination_price']) ? $destination_options['destination_price'] : '';
							$destination_location = isset($destination_options['destination_location']) ? $destination_options['destination_location'] : '';
							$destination_image = isset($destination_options['destination_image']) ? $destination_options['destination_image'] : '';

							global $post;
							$image_url = wp_get_attachment_url($destination_image);
							$image_alt = get_post_meta($destination_image, '_wp_attachment_image_alt', true);
					?>
							<div class="grid">
								<div class="img-holder">
									<?php if ($image_url) {
										echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($image_alt) . '">';
									} ?>
								</div>
								<div class="details">
									<?php
									if ($destination_location) {
										echo '<span class="cat">' . esc_html($destination_location) . '</span>';
									}

									if ($destination_title) {
										echo '<h3><a href="' . esc_url(get_permalink()) . '">' . esc_html($destination_title) . '</a></h3>';
									}
									?>
								</div>
							</div>
					<?php
						endwhile;
					endif;
					wp_reset_postdata();
					?>
				</div>
			</div>
		<?php } else { ?>
			<div class="varaus-destination <?php echo esc_attr($destination_wrap); ?>">
				<div class="<?php echo esc_attr($destination_col); ?>">
					<?php
					if ($varaus_destination->have_posts()) : while ($varaus_destination->have_posts()) : $varaus_destination->the_post();

							$destination_options = get_post_meta(get_the_ID(), 'destination_options', true);
							$destination_title = isset($destination_options['destination_title']) ? $destination_options['destination_title'] : '';
							$destination_date = isset($destination_options['destination_date']) ? $destination_options['destination_date'] : '';
							$destination_days = isset($destination_options['destination_days']) ? $destination_options['destination_days'] : '';
							$destination_price = isset($destination_options['destination_price']) ? $destination_options['destination_price'] : '';
							$destination_location = isset($destination_options['destination_location']) ? $destination_options['destination_location'] : '';
							$destination_image = isset($destination_options['destination_image']) ? $destination_options['destination_image'] : '';

							global $post;
							$image_url = wp_get_attachment_url($destination_image);
							$image_alt = get_post_meta($destination_image, '_wp_attachment_image_alt', true);
					?>
							<div class="item">
								<div class="destination-item">
									<div class="destination-img">
										<?php if ($image_url) {
											echo '<img src="' . esc_url($image_url) . '" alt="' . esc_attr($image_alt) . '">';
										} ?>
									</div>
									<div class="destination-content">
										<div class="content-left">
											<?php
											if ($destination_title) {
												echo '<h5><a href="' . esc_url(get_permalink()) . '">' . esc_html($destination_title) . '</a></h5>';
											}
											if ($destination_date) {
												echo '<small>' . esc_html($destination_date) . '</small>';
											}

											?>
										</div>
										<div class="content-right">
											<?php
											if ($destination_price) {
												echo '<h5>' . esc_html($destination_price) . '</h5>';
											}
											if ($destination_days) {
												echo '<span>' . esc_html($destination_days) . '</span>';
											}
											?>
										</div>
									</div>
								</div>
							</div>
					<?php
						endwhile;
					endif;
					wp_reset_postdata();
					?>
				</div>
			</div>
<?php }
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Destination widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_Destination());
