<?php
/*
 * Elementor Varaus CTA Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_CTA extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_cta';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('CTA', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-posts-ticker';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus CTA widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	/*
	public function get_script_depends() {
		return ['tmx-varaus_cta'];
	}
	*/

	/**
	 * Register Varaus CTA widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_CTA',
			[
				'label' => esc_html__('CTA Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'cta_image',
			[
				'label' => esc_html__('CTA Image', 'varaus-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your image.', 'varaus-core'),
			]
		);
		$this->add_control(
			'cta_play',
			[
				'label' => esc_html__('CTA Play Icon', 'varaus-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your Play Icon.', 'varaus-core'),
			]
		);
		$this->add_control(
			'cta_link',
			[
				'label' => esc_html__('Content Link', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Content Link', 'varaus-core'),
				'placeholder' => esc_html__('Type Content link here', 'varaus-core'),
				'label_block' => true,
			]
		);

		$this->end_controls_section(); // end: Section


		// Button
		$this->start_controls_section(
			'section_content_button_style',
			[
				'label' => esc_html__('Button', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-holder a:before' => 'border-left-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_bg_color',
			[
				'label' => esc_html__('Background Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-holder a' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render CTA widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$cta_style = !empty($settings['cta_style']) ? $settings['cta_style'] : '';
		$cta_link = !empty($settings['cta_link']) ? $settings['cta_link'] : '';

		$cta_image = !empty($settings['cta_image']['id']) ? $settings['cta_image']['id'] : '';
		$cta_play = !empty($settings['cta_play']['id']) ? $settings['cta_play']['id'] : '';

		$play_url = wp_get_attachment_url($cta_play);
		$play_alt = get_post_meta($cta_image, '_wp_attachment_image_alt', true);

		$cta_link = $cta_link ? '<a href="' . esc_url($cta_link) . '" class="video-btn" data-type="iframe"><img src="' . esc_url($play_url) . '" alt="' . esc_url($play_alt) . '"></a>' : '';

		$cta_url = wp_get_attachment_url($cta_image);
		$cta_alt = get_post_meta($cta_image, '_wp_attachment_image_alt', true);

		// Turn output buffer on
		ob_start(); ?>
		<div class="video-banner-area">
			<div class="banner-img">
				<?php if ($cta_url) {
					echo '<img src="' . esc_url($cta_url) . '" alt="' . esc_url($cta_alt) . '">';
				} ?>
				<ul class="banner-video">
					<li class="video-holder">
						<?php echo $cta_link; ?>
					</li>
				</ul>
			</div>
		</div>
<?php // Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render CTA widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_CTA());
