<?php
/*
 * Elementor Varaus ContactInfo Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_ContactInfo extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_contactinfo';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('ContactInfo', 'varaus-core');
	}

	/**
	 * Retrieve the widget item.
	 */
	public function get_item()
	{
		return 'fa fa-telegram';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus ContactInfo widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_contactinfo'];
	}

	/**
	 * Register Varaus ContactInfo widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__('ContactInfo Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'section_info_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Head Office', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_info_content',
			[
				'label' => esc_html__('Content Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('54, Dahs udin sorok, Melborn Austria', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'contact_icon',
			[
				'label' => __('Icon', 'varaus-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fi flaticon-internet',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'contact_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Head Office', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'contact_content',
			[
				'label' => esc_html__('Content Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('54, Dahs udin sorok, Melborn Austria', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'contactinfoItems_groups',
			[
				'label' => esc_html__('Contact Info Items', 'varaus-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'contact_title' => esc_html__('Contact Info', 'varaus-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ contact_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section



		// Icons
		$this->start_controls_section(
			'contactinfo_section_icons_style',
			[
				'label' => esc_html__('Icons', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'contactinfo_icons_typography',
				'selector' => '{{WRAPPER}} .wpo-contact-info .info-icon .fi:before',
			]
		);
		$this->add_control(
			'contactinfo_icons_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpo-contact-info .info-icon .fi:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'contactinfo_icons_padding',
			[
				'label' => __('Icons Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .wpo-contact-info .info-icon .fi:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Sub Title
		$this->start_controls_section(
			'contactinfo_section_subtitle_style',
			[
				'label' => esc_html__('Sub Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'contactinfo_sub_title_typography',
				'selector' => '{{WRAPPER}} .wpo-contact-info .info-icon .fi:before',
			]
		);
		$this->add_control(
			'contactinfo_subtitle_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wpo-contact-info .info-icon .fi:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'contactinfo_subtitle_padding',
			[
				'label' => __('Sub Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .wpo-contact-info .info-icon .fi:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Title
		$this->start_controls_section(
			'contactinfo_section_title_style',
			[
				'label' => esc_html__('Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_title_typography',
				'selector' => '{{WRAPPER}} .wpo-contact-info .info-item h2',
			]
		);
		$this->add_control(
			'contactinfo_title_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-contact-section .contact-form-col .section-title-s2 h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'contactinfo_title_padding',
			[
				'label' => esc_html__('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .varaus-contact-section .contact-form-col .section-title-s2 h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section



	}

	/**
	 * Render ContactInfo widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$contactinfoItems_groups = !empty($settings['contactinfoItems_groups']) ? $settings['contactinfoItems_groups'] : [];
		$section_info_title = !empty($settings['section_info_title']) ? $settings['section_info_title'] : [];
		$section_info_content = !empty($settings['section_info_content']) ? $settings['section_info_content'] : [];

		// Turn output buffer on
		ob_start();
?>
		<div class="contact-info">
			<div class="contact-text">
				<div class="section-title">
					<?php if ($section_info_title) {
						echo '<h2>' . esc_html($section_info_title) . '</h2>';
					} ?>
				</div>
				<div class="contact-details">
					<?php if ($section_info_content) {
						echo '<p>' . esc_html($section_info_content) . '</p>';
					} ?>
					<ul>
						<?php 	// Group Param Output
						if (is_array($contactinfoItems_groups) && !empty($contactinfoItems_groups)) {
							foreach ($contactinfoItems_groups as $each_items) {

								$contact_title = !empty($each_items['contact_title']) ? $each_items['contact_title'] : '';
								$contact_content = !empty($each_items['contact_content']) ? $each_items['contact_content'] : '';
								$contact_icon = !empty($each_items['contact_icon']['value']) ? $each_items['contact_icon']['value'] : '';

								$contact_icon = !empty($each_items['contact_icon']['value']) ? $each_items['contact_icon']['value'] : '';

								$contact_icon = !empty($each_items['contact_icon']['value']) ? $each_items['contact_icon']['value'] : '';
								$contact_svg_url = !empty($each_items['contact_icon']['value']['url']) ? $each_items['contact_icon']['value']['url'] : '';
								$svg_alt = get_post_meta($contact_svg_url, '_wp_attachment_image_alt', true);

						?>
								<li>
									<div class="icon">
										<?php
										if ($contact_svg_url) {
											echo '<img src="' . esc_url($contact_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
										} else {
											echo ' <div class="icon"><i class="' . esc_attr($contact_icon) . '"></i></div>';
										}
										?>
									</div>
									<?php
									if ($contact_title) {
										echo '<h2>' . esc_html($contact_title) . '</h2>';
									}
									if ($contact_content) {
										echo '<p>' . esc_html($contact_content) . '</p>';
									}
									?>
								</li>
						<?php }
						} ?>
					</ul>
				</div>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render ContactInfo widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_ContactInfo());
