<?php
/*
 * Elementor Varaus About Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_About extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_about';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('About', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-site-identity';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus About widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_about'];
	}

	/**
	 * Register Varaus About widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_about',
			[
				'label' => esc_html__('About Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'about_style',
			[
				'label' => __('About Style', 'varaus-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style-one' => esc_html__('Style One', 'varaus-core'),
					'style-two' => esc_html__('Style Two', 'varaus-core'),
				],
				'default' => 'style-one',
				'description' => esc_html__('Select your about style.', 'varaus-core'),
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => esc_html__('Sub Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Sub Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Sub Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_content',
			[
				'label' => esc_html__('Content', 'varaus-core'),
				'default' => esc_html__('your content text', 'varaus-core'),
				'placeholder' => esc_html__('Type your content here', 'varaus-core'),
				'type' => Controls_Manager::WYSIWYG,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_text',
			[
				'label' => esc_html__('Button Text', 'varaus-core'),
				'default' => esc_html__('button text', 'varaus-core'),
				'placeholder' => esc_html__('Type button Text here', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label' => esc_html__('Button Link', 'varaus-core'),
				'type' => Controls_Manager::URL,
				'placeholder' => 'https://your-link.com',
				'default' => [
					'url' => '',
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_image',
			[
				'label' => esc_html__('About Image', 'varaus-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your image.', 'varaus-core'),
			]
		);
		$this->end_controls_section(); // end: Section

		// Sub Title
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__('Sub Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'sub_title_typography',
				'selector' => '{{WRAPPER}} .varaus-about .wpo-section-title span',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-section-title span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_padding',
			[
				'label' => __('Sub Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-section-title span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_title_typography',
				'selector' => '{{WRAPPER}} .varaus-about .wpo-section-title h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-section-title h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-section-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__('Content', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .varaus-about .wpo-about-text p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-about-text p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


		// Button
		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__('Button', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_one_typography',
				'selector' => '{{WRAPPER}} .varaus-about .wpo-about-text .btns .theme-btn-s2',
			]
		);

		$this->start_controls_tabs('button_one_style');
		$this->start_controls_tab(
			'button_one_normal',
			[
				'label' => esc_html__('Normal', 'varaus-core'),
			]
		);
		$this->add_control(
			'button_one_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-about-text .btns .theme-btn-s2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_one_bgcolor',
			[
				'label' => esc_html__('Background Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-about-text .btns .theme-btn-s2' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_padding',
			[
				'label' => __('Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-about-text .btns .theme-btn-s2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();  // end:Normal tab

		$this->start_controls_tab(
			'button_one_hover',
			[
				'label' => esc_html__('Hover', 'varaus-core'),
			]
		);
		$this->add_control(
			'button_one_hover_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-about-text .btns .theme-btn-s2:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_one_hover_bg_color',
			[
				'label' => esc_html__('Background Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .varaus-about .wpo-about-text .btns .theme-btn-s2:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();  // end:Hover tab
		$this->end_controls_tabs(); // end tabs

		$this->end_controls_section(); // end: Section

	}

	/**
	 * Render About widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$about_style = !empty($settings['about_style']) ? $settings['about_style'] : '';
		$sub_title = !empty($settings['sub_title']) ? $settings['sub_title'] : '';
		$about_title = !empty($settings['about_title']) ? $settings['about_title'] : '';
		$about_content = !empty($settings['about_content']) ? $settings['about_content'] : '';
		$bg_image = !empty($settings['about_image']['id']) ? $settings['about_image']['id'] : '';

		$button_text = !empty($settings['btn_text']) ? $settings['btn_text'] : '';
		$button_link = !empty($settings['btn_link']['url']) ? $settings['btn_link']['url'] : '';
		$button_link_external = !empty($settings['btn_link']['is_external']) ? 'target="_blank"' : '';
		$button_link_nofollow = !empty($settings['btn_link']['nofollow']) ? 'rel="nofollow"' : '';
		$button_link_attr = !empty($button_link) ?  $button_link_external . ' ' . $button_link_nofollow : '';

		// Image
		$image_url = wp_get_attachment_url($bg_image);
		$image_alt = get_post_meta($settings['about_image']['id'], '_wp_attachment_image_alt', true);

		$varaus_button = $button_link ? '<a href="' . esc_url($button_link) . '" ' . $button_link_attr . ' class="theme-btn-s2">' . esc_html($button_text) . '</a>' : '';

		if ($about_style == 'style-one') {
			$wrap_class	= 'wpo-about-area';
			$wrap_colclass	= 'col-lg-6 col-md-6 colsm-12';
			$wrap_colclass2	= 'col-lg-6 col-md-6 colsm-12';
		} else {
			$wrap_class	= 'wpo-about-area-2';
			$wrap_colclass	= 'col-lg-6 col-md-6 col-sm-12 col-12';
			$wrap_colclass2	= 'col-lg-6 col-md-6 col-sm-12 col-12';
		}

		// Turn output buffer on
		ob_start(); ?>
		<div class="varaus-about <?php echo esc_attr($wrap_class); ?>">
			<div class="container">
				<div class="row">
					<div class="<?php echo esc_attr($wrap_colclass); ?>">
						<div class="wpo-about-img">
							<?php if ($image_url) {
								echo '<img src="' . esc_url($image_url) . '" alt="' . esc_url($image_alt) . '">';
							} ?>
						</div>
					</div>
					<div class="<?php echo esc_attr($wrap_colclass2); ?>">
						<div class="wpo-about-text">
							<div class="wpo-section-title">
								<?php
								if ($sub_title) {
									echo '<span>' . esc_html($sub_title) . '</span>';
								}
								if ($about_title) {
									echo '<h2>' . esc_html($about_title) . '</h2>';
								}
								?>
							</div>
							<?php if ($about_content) {
								echo wp_kses_post($about_content);
							} ?>
							<div class="btns">
								<?php echo $varaus_button; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
<?php  // Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render About widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_About());
