<?php
/*
 * Elementor Varaus roomsinfo Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_roomsinfo extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_roomsinfo';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Room Info', 'varaus-core');
	}

	/**
	 * Retrieve the widget item.
	 */
	public function get_item()
	{
		return 'eicon-icon-box';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus roomsinfo widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_roomsinfo'];
	}

	/**
	 * Register Varaus roomsinfo widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_roomsinfo',
			[
				'label' => esc_html__('roomsinfo Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'roominfo_style',
			[
				'label' => __('Rooms Info Style', 'zango-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style-one' => esc_html__('Style One', 'zango-core'),
					'style-two' => esc_html__('Style Two', 'zango-core'),
				],
				'default' => 'style-one',
				'description' => esc_html__('Select your feature style.', 'zango-core'),
			]
		);
		$this->add_control(
			'roomsinfo_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Room info', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'room_image',
			[
				'label' => esc_html__('Room Image', 'varaus-core'),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__('Set your image.', 'varaus-core'),
			]
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'room_item',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Start time', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'roomsinfoItems_groups',
			[
				'label' => esc_html__('Room Items', 'varaus-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'room_item' => esc_html__('Room Info', 'varaus-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ room_item }}}',
			]
		);
		$this->end_controls_section(); // end: Section




	}

	/**
	 * Render roomsinfo widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$roomsinfoItems_groups = !empty($settings['roomsinfoItems_groups']) ? $settings['roomsinfoItems_groups'] : [];
		$roominfo_style = !empty($settings['roominfo_style']) ? $settings['roominfo_style'] : '';
		$roomsinfo_title = !empty($settings['roomsinfo_title']) ? $settings['roomsinfo_title'] : '';
		$bg_image = !empty($settings['room_image']['id']) ? $settings['room_image']['id'] : '';
		// Image
		$image_url = wp_get_attachment_url($bg_image);
		$image_alt = get_post_meta($settings['room_image']['id'], '_wp_attachment_image_alt', true);

		// Turn output buffer on
		ob_start();
?>
		<div class="room-details-service">
			<div class="room-details-item">
				<div class="row">
					<?php if ($roominfo_style == 'style-one') { ?>
						<div class="col-md-5 col-sm-5">
							<div class="room-d-text">
								<div class="room-title">
									<?php if ($roomsinfo_title) {
										echo '<h2>' . esc_html($roomsinfo_title) . '</h2>';
									} ?>
								</div>
								<ul>
									<?php 	// Group Param Output
									if (is_array($roomsinfoItems_groups) && !empty($roomsinfoItems_groups)) {
										foreach ($roomsinfoItems_groups as $each_items) {

											$room_item = !empty($each_items['room_item']) ? $each_items['room_item'] : '';
											if ($room_item) {
												echo '<li>' . esc_html($room_item) . '</li>';
											}
										}
									} ?>
								</ul>
							</div>
						</div>
						<div class="col-md-7 col-sm-7">
							<div class="room-d-img">
								<?php if ($image_url) {
									echo '<img src="' . esc_url($image_url) . '" alt="' . esc_url($image_alt) . '">';
								} ?>
							</div>
						</div>
					<?php } else { ?>
						<div class="col-md-7 col-sm-7">
							<div class="room-d-img">
								<?php if ($image_url) {
									echo '<img src="' . esc_url($image_url) . '" alt="' . esc_url($image_alt) . '">';
								} ?>
							</div>
						</div>
						<div class="col-md-5 col-sm-5">
							<div class="room-d-text2">
								<div class="room-title">
									<?php if ($roomsinfo_title) {
										echo '<h2>' . esc_html($roomsinfo_title) . '</h2>';
									} ?>
								</div>
								<ul>
									<?php 	// Group Param Output
									if (is_array($roomsinfoItems_groups) && !empty($roomsinfoItems_groups)) {
										foreach ($roomsinfoItems_groups as $each_items) {

											$room_item = !empty($each_items['room_item']) ? $each_items['room_item'] : '';
											if ($room_item) {
												echo '<li>' . esc_html($room_item) . '</li>';
											}
										}
									} ?>
								</ul>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render roomsinfo widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_roomsinfo());
