<?php
namespace Elementor;

defined( 'ABSPATH' ) || die();

class Varaus_Icons_Manager {

    public static function init() {
        add_filter( 'elementor/icons_manager/additional_tabs', [ __CLASS__, 'add_varaus_icons_tab' ] );
    }

    public static function add_varaus_icons_tab( $tabs ) {
        $tabs['varaus-icons'] = [
            'name' => 'varaus-icons',
            'label' => __( 'Varaus Icons', 'varaus-elementor-addons' ),
            'url' => VARAUS_PLUGIN_URL . 'elementor/assets/css/flaticon.css',
            'enqueue' => [ VARAUS_PLUGIN_URL . 'elementor/assets/css/flaticon.css' ],
            'prefix' => 'flaticon-',
            'displayPrefix' => 'fi',
            'labelIcon' => 'flaticon-standard',
            'ver' => '1.0.0',
            'fetchJson' => VARAUS_PLUGIN_URL . 'elementor/assets/js/varaus-icons.js?v=1.0.0',
            'native' => false,
        ];
        return $tabs;
    }

    /**
     * Get a list of varaus icons
     *
     * @return array
     */
    public static function get_varaus_icons() {
        return [
            'flaticon-support' => 'support',
            'flaticon-calendar'  => 'calendar',
            'flaticon-download' => 'download',
            'flaticon-user' => 'user',
            'flaticon-star' => 'star',
            'flaticon-tray' => 'tray',
            'flaticon-pool' => 'pool',
            'flaticon-wifi-signal' => 'wifi-signal',
            'flaticon-bowling' => 'bowling',
            'flaticon-taxi' => 'taxi',
            'flaticon-breakfast' => 'breakfast',
            'flaticon-herbal' => 'herbal',
            'flaticon-star-1' => 'star-1',
            'flaticon-key' => 'key',
            'flaticon-staff' => 'staff',
            'flaticon-eye' => 'eye',
            'flaticon-heart' => 'heart',
            'flaticon-comment' => 'comment',
            'flaticon-share' => 'share',
            'flaticon-quote' => 'quote',
            'flaticon-play' => 'play',
            'flaticon-chain' => 'chain',
            'flaticon-support-1' => 'support-1',
            'flaticon-null' => 'null',
            'flaticon-null-1' => 'null-1',
            'flaticon-internet' => 'internet',
        ];
    }
}

Varaus_Icons_Manager::init();